CREATE OR REPLACE FUNCTION alterView() 
RETURNS VOID AS 
$BODY$ 
DECLARE
	msgFinal text := 'CRIADA';
BEGIN 
IF EXISTS (SELECT 1 FROM information_schema.columns WHERE table_name= 'v_nfce') THEN 						 
	DROP VIEW v_nfce;
    RAISE NOTICE 'Viso v_nfce FOI REMOVIDA';                             
    msgFinal := 'RECRIADA'::text;
END IF; 


CREATE OR REPLACE VIEW public.v_nfce
AS SELECT cp.cd_emp,
    cp.cd_filial,
    cp.cd_cx,
    cp.cd_vd,
    cp.dt_vd,
    cp.nr_ecf,
    cp.cd_cli,
    cp.cgc_cpf,
    cp.nm_cli,
    cp.vlr_desc,
    cp.vlr_dinh,
    cp.vlr_chqs,
    cp.vlr_troco,
    cp.vlr_cartoes_linx,
    it.cd_benef,
    ( SELECT COALESCE(sum(item.vl_cartao), 0::numeric) AS "coalesce"
           FROM pdv_vd_tef item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_transacao <> 2::numeric AND item.tp_adm <> 6) AS vlr_cartao,
    ( SELECT COALESCE(sum(item.vl_parc), 0::numeric) AS "coalesce"
           FROM pdv_vd_cred item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd) AS vlr_crediario,
    cp.vlr_tickets,
    cp.vlr_conv,
    cp.vlr_dup,
    cp.vlr_ncc,
    cp.st_vd,
    cp.vlr_conv_pbm,
    ( SELECT COALESCE(sum(item.vlr_liq_it), 0::numeric) AS "coalesce"
           FROM pdv_vd_it item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_it = 1::numeric) AS vlr_to_liq_it,
    ( SELECT COALESCE(sum(item.vlr_liq_it), 0::numeric) - cp.vlr_desc
           FROM pdv_vd_it item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_it = 1::numeric) AS vlr_to_liq_vd,
    ( SELECT COALESCE(sum(item.vlr_tot_it), 0::numeric) AS "coalesce"
           FROM pdv_vd_it item
          WHERE item.cd_emp = cp.cd_emp AND item.cd_filial = cp.cd_filial AND item.cd_vd = cp.cd_vd AND item.st_it = 1::numeric) AS vlr_to_bruto_it,
    it.cd_it,
    it.cd_barras AS ean,
    it.cd_prod,
        CASE
            WHEN COALESCE(it.ds_prod_vd, ''::character varying)::text = ''::text THEN p.ds_usual
            ELSE it.ds_prod_vd
        END AS ds_prod,
    p.ncm_prod,
    p.vlr_pmc,
    p.ctr_pmc,
    0 AS ean_trib,
    medidas.ds_un AS cd_un_vd,
    it.qt_it,
    it.vlr_it,
    it.vlr_tot_it,
    it.vlr_desc_it,
    it.vlr_liq_it,
    it.cd_trib_fc,
    it.tx_icms_it,
    it.tx_red_it,
    it.st_it,
    it.tipo_imposto,
    it.cd_vend,
    cp.cd_nf_serie,
    cp.cd_usu,
    cp.vlr_imposto,
    cp.vlr_imposto_uf,
    cp.vlr_imposto_mun,
    it.vlr_desc_tot_rat,
    it.nr_cest,
    COALESCE(p.nr_serv, ''::character varying) AS nr_serv,
    cp.hr_vd,
    cp.tipo_pbm,
    cp.tp_emis,
    pdv_cx.cod_ativacao_mfe,
    pdv_cx.signacmfe,
    COALESCE(it.perc_fcp, 0.0) AS perc_fcp,
    COALESCE(it.perc_fecop_st, 0.0) AS perc_fecop_st,
    COALESCE(it.perc_fecop_ret, 0.0) AS perc_fecop_ret,
    COALESCE(it.perc_icms, 0.0) AS perc_icms,
    COALESCE(it.perc_icms_subst, 0.0) AS perc_icms_subst,
    COALESCE(it.perc_red_base_calc, 0.0) AS perc_red_base_calc,
    COALESCE(it.perc_red_base_calc_efet, 0.0) AS perc_red_base_calc_efet,
    COALESCE(it.perc_icms_efet, 0.0) AS perc_icms_efet,
    COALESCE(it.perc_st, 0.0) AS perc_st,
    COALESCE(it.perc_icms_ret, 0.0) AS perc_icms_ret,
    COALESCE(it.motivo_desonerado_icms, 0::numeric) AS motivo_desonerado_icms,
    COALESCE(it.icms_desonerado, 0::numeric) AS icms_desonerado,
    COALESCE(it.vlr_icms_desonerado_it, 0.0) AS vlr_icms_desonerado_it,
    cp.regime_tributario,
    it.origem_produto,
    it.cfop,
    it.vlr_base_calc,
    it.vlr_base_calc_pis,
    it.vlr_base_calc_cofins,
    it.vlr_icms,
    it.vlr_base_subst,
    it.vlr_isento,
    it.vlr_outras,
    it.vlr_icms_subst,
    it.vlr_fecop,
    it.vlr_fecop_st,
    it.vlr_fecop_ret,
    it.vlr_base_calc_efet,
    it.vlr_icms_efet,
    it.vlr_base_calc_ret,
    it.vlr_icms_ret,
    it.vlr_frete_rat,
    cp.vlr_frete_tot,
    pvo.tp_orc_entg,
    COALESCE(itbc.cst_ibs_cbs, ''::character varying) AS cst_ibs_cbs,
    COALESCE(itbc.class_trib_ibs_cbs, ''::character varying) AS class_trib_ibs_cbs,
    COALESCE(itbc.vlr_bc_ibs_cbs, 0::numeric) AS vlr_bc_ibs_cbs,
    COALESCE(itbc.vlr_ibs_uf, 0::numeric) AS vlr_ibs_uf,
    COALESCE(itbc.vlr_ibs_mun, 0::numeric) AS vlr_ibs_mun,
    COALESCE(itbc.vlr_ibs, 0::numeric) AS vlr_ibs,
    COALESCE(itbc.vlr_cbs, 0::numeric) AS vlr_cbs,
    COALESCE(itbc.perc_ibs_uf, 0::numeric) AS perc_ibs_uf,
    COALESCE(itbc.perc_ibs_mun, 0::numeric) AS perc_ibs_mun,
    COALESCE(itbc.perc_cbs, 0::numeric) AS perc_cbs
   FROM pdv_vd cp
     JOIN pdv_vd_it it ON cp.cd_emp = it.cd_emp AND cp.cd_filial = it.cd_filial AND cp.cd_vd = it.cd_vd
     LEFT JOIN pdv_vd_it_ibs_cbs itbc ON cp.cd_emp = itbc.cd_emp::numeric AND cp.cd_filial = itbc.cd_filial::numeric AND cp.cd_vd = itbc.cd_vd::numeric AND itbc.cd_it::numeric = it.cd_it
     JOIN est_prod p ON it.cd_emp = p.cd_emp AND it.cd_prod = p.cd_prod
     JOIN pdv_cx ON cp.cd_emp = pdv_cx.cd_emp AND cp.cd_filial = pdv_cx.cd_filial AND cp.cd_cx = pdv_cx.cd_cx
     LEFT JOIN est_prod_un_med medidas ON p.cd_emp = medidas.cd_emp AND p.cd_un_vd = medidas.cd_ctr_un
     LEFT JOIN pdv_vd_orc pvo ON pvo.cd_emp = cp.cd_emp AND pvo.cd_filial = cp.cd_filial AND pvo.cd_vd = cp.cd_vd;

  RAISE NOTICE 'Viso v_nfce FOI %', msgFinal::varchar;

END; 

$BODY$ 
LANGUAGE plpgsql VOLATILE 
  COST 100; 
ALTER FUNCTION alterView() OWNER TO postgres; 
SELECT alterView(); 
DROP FUNCTION alterView();
